<?xml version="1.0" encoding="windows-1250"?>
<!--Reference the file name as the href value-->
<?xml-stylesheet type="text/xsl" href="#"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml">

<!-- Output HTML doctype with text/html content-type and without XML declaration-->
<xsl:output method="xml" encoding="windows-1250" version="" indent="yes" standalone="no" media-type="text/html" omit-xml-declaration="yes" doctype-system="about:legacy-compat" />


<!-- Read the children of the stylesheet itself -->
<xsl:template match="xsl:stylesheet">
  <xsl:apply-templates/>
</xsl:template>

<!-- Output the HTML markup-->
<xsl:template match="/">
  <html>
    <head>
		<style type="text/css">
			table {margin: 25px 10px 25px 10px; table-layout: fixed;  width:290mm;}
			table.obramowanie {border-collapse: collapse; border: 2px solid black; border-spacing:0px;  }					
			tr.obramowanie {border-collapse: collapse; border: 2px solid black; border-spacing:0px}					
			th, td {border-collapse: collapse; border: 1px solid black; border-spacing:0px; overflow: hidden;text-overflow: ellipsis; word-wrap: break-word}
			td.opis {width: 10%}
			th.opis {width: 10%}
			td.dane {font-weight: bold}
			td.daneCheck {font-weight: bold; text-align: center}
			td.daneId{font-weight: bold; background-color: silver; text-align: center}	
		</style>
    </head>
    <body>
      <!-- Read matching templates -->
	  <xsl:call-template name="DaneIdentyfikacyjne">
		<xsl:with-param name="daneIdent" select="//node()[local-name() = 'GSWUZ']"/>
	  </xsl:call-template>
	  
	  <xsl:call-template name="szczegolyOferty">
		<xsl:with-param name='szczegoly' select="//node()[local-name() = 'LOFER']"/>
	  </xsl:call-template>
	  
	  <xsl:if test="//node()[local-name()='PODWYKONAWCA']">
		<xsl:call-template name="wykazPodwykonawcow">
			<xsl:with-param name="podwyk" select="//node()[local-name() = 'komunikat']"/>
		</xsl:call-template>
	  </xsl:if>
	  
	  <xsl:if test="//node()[local-name()='LHMWU']">
		<xsl:call-template name="miejsca">
			<xsl:with-param name="miejsce" select="//node()[local-name() ='komunikat']"/>
		</xsl:call-template>
	  </xsl:if>
	  
	  <xsl:if test="//node()[local-name()='BLKRH']">
		<xsl:call-template name="personel">
			<xsl:with-param name="personel" select="//node()[local-name()='komunikat']"/>
		</xsl:call-template>
	  </xsl:if>
	  
	  <xsl:if test="//node()[local-name()='LHWSS']">
		<xsl:call-template name="sprzet">
			<xsl:with-param name="sprzet" select="//node()[local-name()='komunikat']"/>
		</xsl:call-template>
	  </xsl:if>
      <!--<xsl:apply-templates />-->
    </body>
  </html>
</xsl:template>

<!-- Don't reprint text nodes within the xsl:stylesheet node -->
<xsl:template match="text()"/>

<!-- Read non-namespaced nodes within the xsl:stylesheet node -->
<xsl:template name="DaneIdentyfikacyjne">
	<xsl:param name="daneIdent" />
	<table class="obramowanie">
		<tr>						
			<td style="border: 0px; height: 0; width: 45mm"></td> 
			<td style="border: 0px; height: 0; width: 45%"></td> 
			<td style="border: 0px; height: 0; width: 5%"></td> 
			<td style="border: 0px; height: 0; width: 45mm%"></td> 
			<td style="border: 0px; height: 0"></td> 						
		</tr>
		<tr class="obramowanie">
			<th colspan="5">I. DANE IDENTYFIKACYJNE WNIOSKUJCEGO</th>
		</tr>				
		<tr class="obramowanie">
			<th style="border-collapse: collapse; border: 1px solid black; border-spacing:0px" colspan="5">Dane identyfikacyjne i adresowe oferenta - wiadczeniodawcy w rozumieniu ustawy o wiadczeniach opieki zdrowotnej finansowanych ze rodkw publicznych</th>
		</tr>
		<tr>
			<td>Nazwa</td><td colspan="4" class="dane"><xsl:value-of select="$daneIdent/@PNAZW"/></td>
		</tr>
		<tr>
			<td >Adres siedziby</td><td colspan="4" class="dane"><xsl:value-of select="$daneIdent/@ADRES"/></td>
		</tr>
		<tr>
			<td >Kod terytorialny i nzawa</td><td colspan="4" class="dane"><xsl:value-of select="$daneIdent/@PTERYT"/></td>
		</tr>
		<tr>   
			<td>REGON</td><td class="dane" colspan="2"><xsl:value-of select="$daneIdent/@PWREG"/></td>
			<td>NIP</td><td class="dane"><xsl:value-of select="$daneIdent/@PWNIP"/></td>
		</tr>
		<tr>
			<td >Forma organizacyjno-prawna (czesc IV KR)</td><td colspan="4" class="dane"><xsl:value-of select="$daneIdent/@NFRP"/></td>
		</tr>
		<tr>
			<td>Osoba/y uprawniona do reprezentowania</td><td class="dane" colspan="2"><xsl:value-of select="$daneIdent/@DYRN"/></td>
			<td>Telefon</td><td class="dane"><xsl:value-of select="$daneIdent/@PTELE"/></td>
		</tr>
		<tr class="obramowanie">
			<th colspan="5">Dane rejestrowe</th>
		</tr>
		<xsl:for-each select="$daneIdent/*[local-name()='GHSWW']">
			<tr>
				<td>Rodzaj rejestru</td><td colspan="2" class="dane"><xsl:value-of select="@NORG"/></td>
				<td>Nr wpisu do rejestru</td><td class="dane"><xsl:value-of select="@NWPS"/></td>
			</tr>
			<tr>
				<td rowspan="2">Organ rejestrujcy</td><td rowspan="2" colspan="2" class="dane"><xsl:value-of select="@NPRJ"/></td>						
				<td>Data wpisu</td><td class="dane"><xsl:value-of select="@DTWP"/></td>
			</tr>
			<tr>						
				<td >Data ostatniej aktualizacji</td><td class="dane"><xsl:value-of select="@DTOM"/></td>
			</tr>
		</xsl:for-each>
		<tr class="obramowanie">
			<th colspan="5">Certyfikaty</th>
		</tr>
		<tr>
			<td style="text-align:center">Nazwa</td>
			<td style="text-align:center" colspan="3">Zakres certyfikatu</td>
			<td style="text-align:center">Data wanoci</td>
		</tr>
		<xsl:for-each select="$daneIdent/*[local-name()='GHSCR']">
			<tr>
				<td class="dane"><xsl:value-of select="@NCRT"/></td>
				<td colspan="3" class="dane"><xsl:value-of select="@ZCRT"/></td>
				<td class="dane"><xsl:value-of select="@DWAZ"/></td>
			</tr>
		</xsl:for-each>
	</table>	
  <xsl:apply-templates/>
</xsl:template>

<xsl:template name="szczegolyOferty">
	<xsl:param name="szczegoly"/>
	<table class="obramowanie">				
		<tr class="obramowanie">
			<th colspan="7">II. PRZEDMIOT UMOWY, KTREGO DOTYCZY WNIOSEK</th>
		</tr>				
		<xsl:for-each select="$szczegoly/*[local-name()='LSPOF']">
			<tr class="obramowanie">
				<th  colspan="7" >ZAKRES WNIOSKU</th>
			</tr>
			<tr class="obramowanie">
				<td>Kod przedmiotu postpowania</td>
				<td class="dane"><xsl:value-of select="@PBUM"/></td>
				<td>Nazwa przedmiotu postpowania</td>
				<td class="dane" colspan="2"><xsl:value-of select="@NUSL"/></td>
				<td>Populacja</td>
				<td class="dane"><xsl:value-of select="@PPLC"/></td>
			</tr>			
			<xsl:choose>
				<xsl:when test="*[local-name()='GrupyDziedzinowe']">					
						<tr class="obramowanie">
							<th colspan="5">Grupa dziedzinowa</th><th colspan="2">Wybr</th>
						</tr>
						<tr>
							<td colspan="5">Diabetologia</td>
							<td class="daneCheck" colspan="2">
								<xsl:for-each select="*[local-name()='GrupyDziedzinowe']">
									<xsl:if test="@IRDZ=1">
										X
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td colspan="5">Endokrynologia</td>
							<td class="daneCheck" colspan="2">
								<xsl:for-each select="*[local-name()='GrupyDziedzinowe']">
									<xsl:if test="@IRDZ=2">
										X
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td colspan="5">Kardiologia</td>
							<td class="daneCheck" colspan="2">
								<xsl:for-each select="*[local-name()='GrupyDziedzinowe']">
									<xsl:if test="@IRDZ=3">
										X
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>					
						<tr>
							<td colspan="5">Alergologia</td>
							<td class="daneCheck" colspan="2">
								<xsl:for-each select="*[local-name()='GrupyDziedzinowe']">
									<xsl:if test="@IRDZ=4">
										X
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td colspan="5">Pulmonologia</td>
							<td class="daneCheck" colspan="2">
								<xsl:for-each select="*[local-name()='GrupyDziedzinowe']">
									<xsl:if test="@IRDZ=5">
										X
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>					
				</xsl:when>	
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="*[local-name()='LOFOD']">
					<tr class="obramowanie">
						<th colspan="7">Obszar dziaania</th>
					</tr>
					<tr>
						<td>Kod obszaru</td>
						<td colspan="5">Nazwa obszaru</td>
						<td>Populacja</td>
					</tr>
					<xsl:for-each select="*[local-name()='LOFOD']">
						<tr>
							<td class="dane"><xsl:value-of select="@IGMN"/></td>
							<td class="dane" colspan="5"><xsl:value-of select="@NGMN"/></td>
							<td class="dane"><xsl:value-of select="@PPLC"/></td>
						</tr>
					</xsl:for-each>
				</xsl:when>
			</xsl:choose>			
			<xsl:for-each select="*[local-name()='LOZMW']">
				<tr class="obramowanie">
					<th colspan="7">MIEJSCE UDZIELANIA WIADCZE</th>
				</tr>
				<xsl:variable name="LOZMW_IMWU" select="@IMWU"/>
				
				<tr>
					<td rowspan="4" class="daneId"><xsl:value-of select="//node()[local-name()='LHMWU'][@IMWU=$LOZMW_IMWU]/@IMWU"/></td>										
				</tr>
				<tr>
					<td>Nazwa miejsca udzielania wiadcze</td>										
					<td colspan="5" class="dane"><xsl:value-of select="//node()[local-name()='LHMWU'][@IMWU=$LOZMW_IMWU]/@NMWU"/></td>
				</tr>
				<tr>
					<td>Adres miejsca</td>
					<td colspan="3" class="dane"><xsl:value-of select="//node()[local-name()='LHMWU'][@IMWU=$LOZMW_IMWU]/@ADRES"/></td>
					<td>Teryt</td>
					<td class="dane"><xsl:value-of select="//node()[local-name()='LHMWU'][@IMWU=$LOZMW_IMWU]/@IGMN"/></td>
				</tr>
				<tr>
					<td>Kod komrki org. (cz VII KR)</td>
					<td class="dane"><xsl:value-of select="//node()[local-name()='LHMWU'][@IMWU=$LOZMW_IMWU]/@REST"/></td>
					<td>Specjalno komrki org. (cz. VIII KR)</td>
					<td colspan="3" class="dane"><xsl:value-of select="//node()[local-name()='LHMWU'][@IMWU=$LOZMW_IMWU]/@OKSB"/></td>
				</tr>
				<xsl:choose>
					<xsl:when test="*[local-name()='LOFGP']">
						<tr class="obramowanie">
							<th colspan="7">Dostpno</th>
						</tr>
						<tr>
							<td colspan="5">Dostpno profilu medycznego/zakresu</td>
							<td class="dane" colspan="2">WG HARMONOGRAMU</td>
						</tr>
						<tr>
							<td colspan="7">Harmonogram dostpnoci profilu medycznego/zakresu</td>
						</tr>
						<tr>
							<td>pon</td><td>wt</td><td>r</td><td>czw</td><td>pt</td><td>sb</td><td>niedz</td>
						</tr>
						<tr>
							<td class="dane">									
								<xsl:for-each select="*[local-name()='LOFGP']">
									<xsl:if test="@DTYG=1">
										<xsl:value-of select="@CZAS"/><br/>
									</xsl:if>
								</xsl:for-each>										
							</td>
							<td class="dane">
								<xsl:for-each select="*[local-name()='LOFGP']">
									<xsl:if test="@DTYG=2">
										<xsl:value-of select="@CZAS"/><br/>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td class="dane">
								<xsl:for-each select="*[local-name()='LOFGP']">
									<xsl:if test="@DTYG=3">
										<xsl:value-of select="@CZAS"/><br/>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td class="dane">
								<xsl:for-each select="*[local-name()='LOFGP']">
									<xsl:if test="@DTYG=4">
										<xsl:value-of select="@CZAS"/><br/>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td class="dane">
								<xsl:for-each select="*[local-name()='LOFGP']">
									<xsl:if test="@DTYG=5">
										<xsl:value-of select="@CZAS"/><br/>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td class="dane">
								<xsl:for-each select="*[local-name()='LOFGP']">
									<xsl:if test="@DTYG=6">
										<xsl:value-of select="@CZAS"/><br/>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td class="dane">
								 <xsl:for-each select="*[local-name()='LOFGP']">
									<xsl:if test="@DTYG=7">
										<xsl:value-of select="@CZAS"/><br/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>								
					</xsl:when>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="*[local-name()='LOFLK']">
						<tr class="obramowanie">
							<th colspan="7">Personel</th>
						</tr>
						<xsl:for-each select="*[local-name()='LOFLK']">
							<xsl:variable name="LOFLK_ILKR" select="@ILKR"/>
							<tr>
								<td rowspan="3" class="daneId"><xsl:value-of select="//node()[local-name()='BLKRH'][@ILKR=$LOFLK_ILKR]/@LP"/></td>
							</tr>
							<tr>
								<td>Nazwisko</td>
								<td colspan="5" class="dane"><xsl:value-of select="//node()[local-name()='BLKRH'][@ILKR=$LOFLK_ILKR]/@NAZW"/></td>
							</tr>
							<tr>
								<td>Imiona</td>
								<td colspan="3" class="dane"><xsl:value-of select="//node()[local-name()='BLKRH'][@ILKR=$LOFLK_ILKR]/@IMIE"/></td>
								<td>PESEL</td>
								<td class="dane"><xsl:value-of select="//node()[local-name()='BLKRH'][@ILKR=$LOFLK_ILKR]/@WPSL"/></td>
							</tr>
							<tr>
								<td>Zawd/ specjalno</td>
								<td colspan="2" class="dane"><xsl:value-of select="@IDZN"/> - <xsl:value-of select="@NAZW_ZAW"/></td>
								<td>Stopie specjalizacji</td>
								<td class="dane"><xsl:value-of select="@STSP"/></td>
								<td>Nr Prawa Wyk. Zawodu</td>
								<td class="dane"><xsl:value-of select="@NPWZ"/></td>
							</tr>
							<tr>
								<td colspan="2">Stanowisko/funkcja pracownika</td>
								<td class="dane" colspan="3"><xsl:value-of select="@NSFO"/></td>
								<td>Liczba godzin pracy tygodniowo</td>
								<td class="dane"><xsl:value-of select="@WCZG"/>h <xsl:value-of select="@WCZM"/>m</td>
							</tr>
							<tr>
								<td>pon</td><td>wt</td><td>r</td><td>czw</td><td>pt</td><td>sb</td><td>niedz</td>
							</tr>
							<tr>
								<td class="dane">									
									<xsl:for-each select="*[local-name()='LOFGL']">
										<xsl:if test="@DTYG=1">
											<xsl:value-of select="@CZAS"/><br/>
										</xsl:if>
									</xsl:for-each>
									<xsl:choose>
										<xsl:when test="*[local-name()='LOFGL']">
										</xsl:when>
										<xsl:otherwise>
											<br/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="dane">
									<xsl:for-each select="*[local-name()='LOFGL']">
										<xsl:if test="@DTYG=2">
											<xsl:value-of select="@CZAS"/><br/>
										</xsl:if>
									</xsl:for-each>
								</td>
								<td class="dane">
									<xsl:for-each select="*[local-name()='LOFGL']">
										<xsl:if test="@DTYG=3">
											<xsl:value-of select="@CZAS"/><br/>
										</xsl:if>
									</xsl:for-each>
								</td>
								<td class="dane">
									<xsl:for-each select="*[local-name()='LOFGL']">
										<xsl:if test="@DTYG=4">
											<xsl:value-of select="@CZAS"/><br/>
										</xsl:if>
									</xsl:for-each>
								</td>
								<td class="dane">
									<xsl:for-each select="*[local-name()='LOFGL']">
										<xsl:if test="@DTYG=5">
											<xsl:value-of select="@CZAS"/><br/>
										</xsl:if>
									</xsl:for-each>
								</td>
								<td class="dane">
									<xsl:for-each select="*[local-name()='LOFGL']">
										<xsl:if test="@DTYG=6">
											<xsl:value-of select="@CZAS"/><br/>
										</xsl:if>
									</xsl:for-each>
								</td>
								<td class="dane">
									 <xsl:for-each select="*[local-name()='LOFGL']">
										<xsl:if test="@DTYG=7">
											<xsl:value-of select="@CZAS"/><br/>
										</xsl:if>
									</xsl:for-each>
								</td>
							</tr>
							<xsl:choose>
								<xsl:when test="//node()[local-name()='BLKRH'][@ILKR=$LOFLK_ILKR]/CDSZW">
									<tr class="obramowanie">
										<th colspan="7">Dowiadczenie</th>
									</tr>
									<xsl:for-each select="//node()[local-name()='BLKRH'][@ILKR=$LOFLK_ILKR]/CDSZW">
										<tr>
											<td>Nazwa</td>
											<td class="dane" colspan="6"><xsl:value-of select="@NDZW"/></td>
										</tr>
									</xsl:for-each>
								</xsl:when>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="/komunikat/BLKRH[@ILKR=$LOFLK_ILKR]/CWKST">
									<tr class="obramowanie">
										<th colspan="7">Wyksztacenie</th>
									</tr>
									<xsl:for-each select="/komunikat/BLKRH[@ILKR=$LOFLK_ILKR]/CWKST">
										<tr>
											<td>Nazwa</td>
											<td class="dane" colspan="6"><xsl:value-of select="@NWKS"/></td>
										</tr>
									</xsl:for-each>
								</xsl:when>
							</xsl:choose>
						</xsl:for-each>
					</xsl:when>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="*[local-name()='LHODS']">
						<tr class="obramowanie">
							<th colspan="7">Sprzt</th>
						</tr>
						<xsl:for-each select="*[local-name()='LHODS']">
							<xsl:variable name="LHODS_IWSS" select="@IWSS"/>
							<tr>
								<td class="daneId"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@LP"/></td>
								<td>Nazwa sprztu</td>
								<td class="dane" colspan="3"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@NAZW"/></td>
								<td>Ilo</td>
								<td class="dane"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@ILOS"/></td>
							</tr>
							<tr>
								<td>Rodzaj dostpnoci sprztu</td>
								<td class="dane"><xsl:value-of select="@LKSP"/></td>
								<td>Rok produkcji</td>
								<td class="dane"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@ROKP"/></td>
								<td>Nr seryjny sprztu</td>
								<td class="dane" colspan="2"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@SERI"/></td>
							</tr>
						</xsl:for-each>
					</xsl:when>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="*[local-name()='LHODS1']">
						<tr class="obramowanie">
							<th colspan="7">Pojazdy</th>
						</tr>
						<xsl:for-each select="*[local-name()='LHODS1']">
							<xsl:variable name="LHODS_IWSS" select="@IWSS"/>
							<tr>
								<td class="daneId"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@LP"/></td>
								<td>Nazwa pojazdu</td>
								<td class="dane" colspan="3"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@NAZW"/></td>
								<td>Ilo</td>
								<td class="dane"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@ILOS"/></td>
							</tr>
							<tr>
								<td>Rodzaj dostpnoci pojazdu</td>
								<td class="dane"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@DOST"/></td>
								<td>Rok produkcji</td>
								<td class="dane"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@ROKP"/></td>
								<td>Nr rejestracyjny</td>
								<td class="dane" colspan="2"><xsl:value-of select="//node()[local-name()='LHWSS'][@IWSS=$LHODS_IWSS]/@SERI"/></td>
							</tr>
						</xsl:for-each>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>					
		</xsl:for-each>				
	</table>
	<xsl:apply-templates />
</xsl:template>

<xsl:template name="wykazPodwykonawcow">	
		<xsl:param name="podwyk"/>
		<table class="obramowanie">
			<tr>
				<td style="border: 0px; height: 0%; width:160px"></td>
				<td style="border: 0px; height: 0%; width:40%"></td>
				<td style="border: 0px; height: 0%; width:25%"></td>
				<td style="border: 0px; height: 0%"></td>
			</tr>
			<tr>
				<th colspan="4">III. WYKAZ PODWYKONAWCW</th>
			</tr>
			<xsl:for-each select="$podwyk/*[local-name()='PODWYKONAWCA']">
				<tr>
					<td class="daneId">Unikalny wyrnik podwykonawcy</td>
					<td class="dane" colspan="3"><xsl:value-of select="@ISWU"/></td>
				</tr>
				<tr class="obramowanie">
					<th colspan="4">Dane identyfikacyjne podwykonawcy</th>
				</tr>
				<tr>
					<td>Nazwa</td>
					<td class="dane" colspan="3"><xsl:value-of select="@PNAZW"/></td>
				</tr>
				<tr>
					<td>Adres siedziby</td>
					<td class="dane" colspan="3"><xsl:value-of select="@ADRES_PODM"/></td>
				</tr>
				<tr>
					<td>Kod terytorialny i nazwa</td>
					<td class="dane" colspan="3"><xsl:value-of select="@IGMN"/> <xsl:value-of select="concat(' ',@NGMN)"/></td>
				</tr>
				<tr>
					<td>REGON</td><td class="dane"><xsl:value-of select="@PWREG"/></td>
					<td>NIP</td><td class="dane"><xsl:value-of select="@PWNIP"/></td>
				</tr>
				<tr>
					<td>Forma organizacyjno-prawna (cz IV KR)</td>
					<td class="dane" colspan="3"><xsl:value-of select="@NFRP"/></td>
				</tr>
				<tr>
					<td>Osoba/y uprawniona do reprezentowania</td><td class="dane"><xsl:value-of select="@DYRN"/></td>
					<td>Telefon</td><td class="dane"><xsl:value-of select="@PTELE"/></td>
				</tr>
				<tr class="obramowanie">
					<th colspan="4">Dane rejestrowe podwykonawcy</th>
				</tr>
				<xsl:for-each select="*[local-name()='GHSWW']">
					<tr>
						<td>Rodzaj rejestru</td><td class="dane"><xsl:value-of select="@NORG"/></td>
						<td>Nr wpisu do rejestru</td><td class="dane"><xsl:value-of select="@NWPS"/></td>
					</tr>
					<tr>
						<td rowspan="2">Organ rejestrujcy</td><td rowspan="2" class="dane"><xsl:value-of select="@NPRJ"/></td>
						<td>Data wpisu</td><td class="dane"><xsl:value-of select="@DTWP"/></td>
					</tr>
					<tr>						
						<td >Data ostatniej aktualizacji</td><td class="dane"><xsl:value-of select="@DTOM"/></td>
					</tr>
				</xsl:for-each>
				<tr class="obramowanie">
					<th colspan="4">Dane dotyczce formy i przedmiotu umowy podwykonawstwa</th>
				</tr>		
				<xsl:for-each select="*[local-name()='LHUMP']">
					<tr>
						<td rowspan="2">Umowa/promesa</td><td rowspan="2" class="dane"><xsl:value-of select="@TUMP"/></td>
						<td>Data od kiedy obowizuje lub bdzie obowizywa umowa</td><td class="dane"><xsl:value-of select="@DTPO"/></td>
					</tr>
					<tr>						
						<td>Data od kiedy obowizuje lub bdzie obowizywa umowa</td><td class="dane"><xsl:value-of select="@DTKO"/></td>
					</tr>
					<tr>
						<td colspan="4" style="border-spacing:0; border:0; padding: 0 0 0 0">
							<table style="margin: 0 0 0 0; border-spacing:0; width:100% border:0">
								<tr>
									<td style="width:160px; border: 0">Przedmiot wiadcze podwykonywanych</td><td class="dane" style="width:20%; border-top:0; border-bottom:0"><xsl:value-of select="@ZUMW"/></td>
									<td style="width:10%; border:0">Opis</td><td class="dane" style=" border-top:0; border-bottom:0"><xsl:value-of select="@ZOPS"/></td>
								</tr>
							</table>
						</td>
						
					</tr>
				</xsl:for-each>
			</xsl:for-each>
		</table>		
	<xsl:apply-templates/>
</xsl:template>

<xsl:template name="miejsca">
	<xsl:param name="miejsce"/>
	<table class="obramowanie">
		<tr>
			<th colspan="6">IV. WYKAZ MIEJSC UDZIELANIA WIADCZE</th>
		</tr>
		<xsl:for-each select="$miejsce/*[local-name()='LHMWU']">
			<tr>
				<td class="daneId">UNIKALNY WYRӯNIK MIEJSCA</td><td class="dane"><xsl:value-of select="@IMWU"/></td>
				<td>Wyrnik podwykonawcy</td><td class="dane"></td>
				<td>Miejsce dziaania</td><td class="dane">
					<xsl:choose>
						<xsl:when test="@TMWU=0">
							stae
						</xsl:when>
						<xsl:when test="@TMWU=1">
							mobilne
						</xsl:when>
						<xsl:when test="@TMWU=2">
							dom pacjenta
						</xsl:when>
						<xsl:when test="@TMWU=3">
							szkoa
						</xsl:when>
					</xsl:choose>							
				</td>
			</tr>
			<tr>
				<th colspan="6">Dane miejsca udzielania wiadcze</th>
			</tr>
			<tr>
				<td>Nazwa</td>
				<td class="dane" colspan="5"><xsl:value-of select="@NMWU"/></td>
			</tr>
			<tr>
				<td>Unikalny kod komrki org. (cz. VII KR)</td><td class="dane"><xsl:value-of select="@REST"/></td>
				<td>Specjalno komrki org. (cz. VIII KR)</td><td class="dane" colspan="3"><xsl:value-of select="@OKSB"/><xsl:value-of select="concat(' - ', @OKNZ)"/> </td>
			</tr>
			<tr>
				<th colspan="6">Lokalizacja</th>					
			</tr>
			<tr>
				<td>Adres</td><td class="dane" colspan="3"><xsl:value-of select="@ADRES"/></td>
				<td>Kod terytorialny</td><td class="dane"><xsl:value-of select="@IGMN"/></td>
			</tr>
			<tr>
				<th colspan="6">Dane profili medycznych miejsca udzielania wiadcze</th>
			</tr>
			<tr>
				<td class="daneId" style="font-weight:1">Unikalny wyrnik profilu</td>
				<td>Kod profilu</td>
				<td colspan="4">Nazwa profilu</td>
			</tr>
			<xsl:for-each select="*[local-name()='LHMWP']">
				<tr>
					<td class="dane"><xsl:value-of select="@LP"/></td>
					<td class="dane"><xsl:value-of select="@KOD"/></td>
					<td class="dane" colspan="4"><xsl:value-of select="@NAZWA"/></td>
				</tr>
			</xsl:for-each>
		</xsl:for-each>
	</table>		
	<xsl:apply-templates/>
</xsl:template>

<xsl:template name="personel">
	<xsl:param name="personel"/>
	<table class="obramowanie">
		<tr style="text-align:center">
			<td style="border: 0px; height: 0%; width:80px"></td>
			<td style="border: 0px; height: 0%; width:100px"></td>
			<td style="border: 0px; height: 0%;"></td>
			<td style="border: 0px; height: 0%;"></td>
			<td style="border: 0px; height: 0%;"></td>
			<td style="border: 0px; height: 0%;"></td>
			<td style="border: 0px; height: 0%;"></td>
		</tr>
		<tr>
			<th colspan="7">V. WYKAZ PERSONELU</th>
		</tr>
		<xsl:for-each select="$personel/*[local-name()='BLKRH']">
			<tr style="text-align:center">
				<td class="daneId" style="font-weight:1">Unikalny wyrnik osoby</td>
				<td>PESEL</td>
				<td>Nazwisko</td>
				<td>Imiona</td>
				<td>Dostpny czy deklarowany</td>
				<td>Od kiedy pracownik bdzie dostpny</td>
				<td>Miesiczny, redni godzinowy czas pracy</td>
			</tr>
			<tr>
				<td class="dane"><xsl:value-of select="@LP"/></td>
				<td class="dane"><xsl:value-of select="@WPSL"/></td>
				<td class="dane"><xsl:value-of select="@NAZW"/></td>
				<td class="dane"><xsl:value-of select="@IMIE"/></td>
				<td class="dane"><xsl:value-of select="@DOS_DEK"/></td>
				<td class="dane"><xsl:value-of select="@OD_KIEDY"/></td>
				<td class="dane"><xsl:value-of select="@SMCG"/>h 
					<xsl:if test="@SMCM > 0">
						<xsl:value-of select="@SMCM"/>m
					</xsl:if>
				</td>
			</tr>
			<tr>
				<th colspan="7">Uprawnienia zawodowe</th>
			</tr>
			<tr style="text-align:center">
				<td colspan="5">Grupa zawodowa</td>
				<td colspan="2">Nr Prawa Wyk. Zawodu</td>
			</tr>
			<xsl:for-each select="*[local-name()='LHUZO']">
				<tr>
					<td colspan="5" class="dane"><xsl:value-of select="@NRUP"/></td>
					<td colspan="2" class="dane"><xsl:value-of select="@NPWZ"/></td>
				</tr>
			</xsl:for-each>
			<tr>
				<th colspan="7">Zawody/specjalnoci</th>
			</tr>
			<tr style="text-align:center">
				<td colspan="3">Nazwa</td>
				<td colspan="2">Stopie specjalnoci</td>
				<td>Data uzyskania</td>		
				<td>Data otwarcia</td>
			</tr>
			<xsl:for-each select="*[local-name()='CSPLK']">
				<tr>
					<td colspan="3" class="dane"><xsl:value-of select="@NSPL"/></td>
					<td colspan="2" class="dane"><xsl:value-of select="@STSP"/></td>
					<td class="dane"><xsl:value-of select="@DTUZ"/></td>
					<td class="dane"><xsl:value-of select="@DTOT"/></td>
				</tr>
			</xsl:for-each>
		</xsl:for-each>
	</table>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template name="sprzet">
	<xsl:param name="sprzet"/>
		<div class="landscape" style="font-size:12px">
			<table class="obramowanie" style="width:295mm">
				<tr>
					<td style="border: 0px; height: 0%; width:60px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%; width:220px"></td>
					<td style="border: 0px; height: 0%; width:50px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%; width:80px"></td>
					<td style="border: 0px; height: 0%;"></td>	
				</tr>
				<tr>
					<th colspan="12">VI. WYKAZ SPRZETU I POJAZDW</th>
				</tr>
				<tr style="text-align:center">
					<td class="daneId" style="font-weight:0">Unikalny wyrnik sprztu i pojazw</td>
					<td>Unikallny wyrnik podwykonawcy</td>
					<td>Nazwa sprztu i pojazdw</td>
					<td>Ilo</td>
					<td>Model</td>
					<td>Nr seryjny/Nr rejestracyjny</td>
					<td>Rok produkcji</td>
					<td>Status</td>
					<td>Data uzyskania</td>
					<td>Kod UMDNS</td>
					<td>Umowa serwisowa</td>
					<td>Dostpno dla innych komrek</td>
				</tr>
				<xsl:for-each select="$sprzet/*[local-name()='LHWSS']">
					<tr>
						<td class="dane"><xsl:value-of select="@LP"/></td>
						<td class="dane"><xsl:value-of select="@IDPD"/></td>
						<td class="dane"><xsl:value-of select="@NAZW"/></td>
						<td class="dane"><xsl:value-of select="@ILOS"/></td>
						<td class="dane"><xsl:value-of select="@SMOD"/></td>
						<td class="dane"><xsl:value-of select="@SERI"/></td>
						<td class="dane"><xsl:value-of select="@ROKP"/></td>
						<td class="dane">
							<xsl:choose>
								<xsl:when test="@POSD=1">
									POSIADAM
								</xsl:when>
								<xsl:otherwise>
									BD POSIADA
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="dane"><xsl:value-of select="@DPOS"/></td>
						<td class="dane"><xsl:value-of select="@UMDN"/></td>								
						<td class="dane">
							<xsl:choose>
								<xsl:when test="@SERW=1">
									TAK
								</xsl:when>
								<xsl:otherwise>
									NIE
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="dane"><xsl:value-of select="@DOST"/></td>	
					</tr>
				</xsl:for-each>
			</table>
		</div>
	<xsl:apply-templates/>
</xsl:template>

</xsl:stylesheet> 